#!/bin/bash

# Vérifie que le script est lancé avec sudo ou root
if [[ $EUID -ne 0 ]]; then
   echo "Ce script doit être lancé en tant que root ou avec sudo."
   exit 1
fi

# Démarrage de Webmin
echo "Démarrage du service Webmin..."
systemctl start webmin

# Attente pour s'assurer que le service est bien lancé
sleep 10

# Récupération de l'adresse IP de la machine (optionnelle)
IP=$(hostname -I | awk '{print $1}')

echo ""
echo "************************************************************************"
echo "Webmin est maintenant actif !"
echo "Ouvre ton navigateur et va sur :"
echo ""
echo "    https://${IP:-localhost}:10000"
echo ""
echo "************************************************************************"
echo ""

# Demande à l'utilisateur de valider la fin de l'utilisation
read -p "Appuie sur Entrée quand tu as fini d'utiliser Webmin..."

# Arrêt de Webmin
echo "Arrêt du service Webmin..."
systemctl stop webmin
echo "Webmin a été arrêté."

