#!/bin/bash

# Vérification des droits root
if [ "$(id -u)" -ne 0 ]; then
    echo "Ce script doit être exécuté en tant que root ou avec sudo."
    exit 1
fi

# Arrêt du service Webmin
echo "Arrêt du service Webmin..."
systemctl stop webmin 2>/dev/null || service webmin stop 2>/dev/null

# Désinstallation de Webmin
echo "Désinstallation de Webmin..."
apt-get purge -y webmin

# Suppression du dossier de configuration (optionnel)
echo "Suppression des fichiers de configuration de Webmin..."
rm -rf /etc/webmin

sudo sed -i '/webmin\.com\/download\/repository/d' /etc/apt/sources.list.d/additional-repositories.list

# Mise à jour de la base de données des paquets
echo "Mise à jour de la base de données des paquets..."
apt-get update

echo "Webmin a été désinstallé proprement."
