#!/bin/bash
set -e

WEBMIN_DEB_URL="https://www.webmin.com/download/deb/webmin-current.deb"

echo "=== Installation de Webmin pour Debian/Ubuntu ==="

# Vérifier et installer wget si besoin
if ! command -v wget >/dev/null 2>&1; then
    echo "wget n'est pas installé. Installation..."
    sudo apt-get update
    sudo apt-get install -y wget
fi

# Télécharger le paquet Webmin
echo "Téléchargement de Webmin depuis :"
echo "$WEBMIN_DEB_URL"
wget -O webmin-current.deb "$WEBMIN_DEB_URL"

# Installer Webmin
echo "Installation du paquet..."
sudo apt-get install -y ./webmin-current.deb

# Nettoyer le fichier téléchargé
rm -f webmin-current.deb

# Ouvrir le port 10000 si UFW est installé
if command -v ufw >/dev/null 2>&1; then
    echo "Ouverture du port 10000 sur le pare-feu UFW..."
    sudo ufw allow 10000/tcp
fi

# Détecter l'adresse IP locale principale
IP_LOCAL=$(hostname -I | awk '{print $1}')

echo ""
echo "=== Installation terminée ! ==="
echo "Accédez à Webmin via ce lien sur cette machine :"
echo "👉 https://localhost:10000"
echo ""
echo "Ou depuis un autre appareil du réseau :"
echo "👉 https://$IP_LOCAL:10000"
echo ""
echo "Remarque : Un avertissement de sécurité du navigateur est normal lors de la première connexion."

