#!/bin/bash
# Attendre 2 minutes que le système soit démarré (réseau..) sinon on n'a pas de connexion internet
#### déplacé dans la ligne du crontab root :   @reboot sleep 120; /home/pjm/bin/update-day.sh

LOG="/var/log/update-day.log"
DATE=$(date +"%Y-%m-%d %H:%M")
export DEBIAN_FRONTEND=noninteractive

echo "============================  $DATE  ==============================" >> "$LOG"
sudo apt-get update -y >> "$LOG" 2>&1

# Compte le nombre de paquets pouvant être mis à jour
UPGRADABLE=$(apt list --upgradable 2>/dev/null | grep -iv "list" | wc -l)
if [ "$UPGRADABLE" -eq 0 ]; then
    echo "Aucune mise à jour disponible. Le script s'arrête." >> "$LOG" 2>&1
    exit 0
fi

echo "$UPGRADABLE mises à jour disponibles. Lancement de la mise à jour..." >> "$LOG" 2>&1

sudo apt-get upgrade -y -o Dpkg::Options::="--force-confdef" -o Dpkg::Options::="--force-confold" >> "$LOG" 2>&1

# Nettoyage des paquets inutiles
sudo apt-get autoremove -y >> "$LOG" 2>&1
sudo apt-get autoclean >> "$LOG" 2>&1

# Suppression des anciens noyaux en conservant les 3 plus récents
kernels_to_remove=$(dpkg -l 'linux-image-*' | awk '/^ii/{print $2}' | grep -E '[0-9]' | grep -v "$(uname -r)" | sort -V | head -n -3)
if [ -n "$kernels_to_remove" ]; then
    echo "Suppression des anciens noyaux :" >> "$LOG"
    echo "$kernels_to_remove" | xargs sudo apt-get -y purge >> "$LOG" 2>&1
fi

echo "Mise à jour terminée à $DATE" >> "$LOG"

# Garder seulement les 1000 dernières lignes du log
tail -n 1000 "$LOG" > "${LOG}.tmp" && mv "${LOG}.tmp" "$LOG"
