﻿#!/bin/sh
# SecuPC.fr - Post-installation paquets et dependances

cp ./pf-setup-fr-6* $HOME/Téléchargements
cd $HOME/Téléchargements

# Mint 2025 - codecs
sudo add-apt-repository multiverse
sudo add-apt-repository restricted
sudo apt-get update -y
sudo apt-get install -y mint-meta-codecs

sudo apt-get update -y &&  sudo apt-get upgrade -y
sudo apt-get install -y inxi hardinfo sysinfo htop 
sudo apt-get install -y vim pluma gedit terminator build-essential
sudo apt-get install -y inkscape kolourpaint digikam pix
sudo apt-get install -y gparted hfsprogs parted gdisk gpart partitionmanager # partitionner avec interface graph
sudo apt-get install -y audacity lame
sudo apt-get install -y brasero vlc k3b
sudo apt-get install -y meld transmission
sudo apt-get install -y pinta vlc cheese inkscape shotwell scribus photflare
sudo apt-get install -y unace rar unrar unar p7zip-rar p7zip zip unzip arj libuu0 mpack sharutils uudeview tree
sudo apt-get install -y cdrdao asunder lame picard soundconverter sound-juicer 
sudo apt-get install -y puddletag usbview libimobiledevice-utils
sudo apt-get install -y htop lynis
sudo apt-get install -y xournal* debhelper perl-tk xzdec texlive-binaries-sse2 hintview texlive-latex-extra

## Jeux classiques
sudo apt-get install -y aisleriot gnome-cards-data sdl-ball gnome-mahjongg gnome-mines gnome-chess gnome-sudoku
sudo apt-get install -y lbreakout2 gnome-games dreamchess chromium-bsu neverputt tuxmath open-invaders xgalaga 

## Cartes SD de grandes capacités
sudo apt-get install -y exfat-utils exfat-fuse

## Samba et Scanners
sudo apt-get install -y xsane synaptic 
sudo apt-get install -y samba smb-client 
sudo apt-get install -y python3-smbc
sudo apt-get install -y filezilla

# Backups
sudo apt-get install -y deja-dup timeshift

# Icones et Polices pour avoir un beau Bureau
###sudo apt-get install -y  xubuntu*font* xubuntu*wallpaper*

# Montages videos
sudo apt-get install -y libimage* gstreamer* libdvdcss2 handbrake simplescreenrecorder kdenlive

# Keepass : Gestionnaire de mots de passe
sudo apt-get install -y keepass2

# ClipGrab
sudo apt-get install -y ffmpeg* qtbase5-dev qtwebengine5-dev youtube-dl
sudo add-apt-repository ppa:clipgrab-team/ppa -y
sudo apt-get update -y &&  sudo apt-get upgrade -y
sudo apt-get install -y clipgrab

# Skype
# wget https://go.skype.com/skypeforlinux-64.deb
# sudo dpkg -i ./skypeforlinux-64.deb

# plugins de XFCE (si Xubuntu)
sudo apt-get install -y  xfce4*plugin

# imprimantes HP, EPSON, FUJITSU, ... et PDF
sudo apt-get install -y  task-print-server cups printer-driver*
sudo apt-get install -y  system-config-printer-gnome 
# sudo apt-get install -y  hplip hplip-gui
sudo apt-get install -y  unattended-upgrades apt-listchanges

# Outils OCR
sudo apt-get install -y tesseract-ocr ocr*  libjpeg6*

# Outils Cartes Mentales
sudo apt-get install -y xmind-vana minder

## Installer Wine en avance de phase
sudo apt-get install -y wine-stable

# Photofiltre (il faut le reinstaller avec chaque User pour raccourcis bureau + dossiers Images)
### plus dispo en ligne ! wget http://photofiltre.free.fr/utils/pf-setup-fr-653.exe
wine ./pf-setup-fr-653.exe
## PhotoFlare sinon
wget https://launchpad.net/photofiltre-lx/trunk/v1.5/+download/PhotoFlare_CE_1.5_amd64_16.04.deb
sudo dpkg -i PhotoFlare_CE_1.5_amd64_16.04.deb
sudo apt-get install -fy

# Teamviewer :
# wget https://download.teamviewer.com/download/linux/teamviewer_amd64.deb
# sudo dpkg -i ./teamviewer_amd64.deb 
# sudo apt-get install -fy

# RUSTDESK : controle a distance OpenSource
# Script Bash proposé par linux.secupc.fr
##########################################
# Récupère les infos de la dernière version RustDesk via l'API GitHub
echo "Récupération des infos de la dernière version de RustDesk"
RELEASE_JSON=$(curl -s https://api.github.com/repos/rustdesk/rustdesk/releases/latest)
# Extrait l'URL du fichier .deb 64 bits
DEB_URL=$(echo "$RELEASE_JSON" | grep browser_download_url | grep 'x86_64\.deb' | cut -d '"' -f 4)
if [ -z "$DEB_URL" ]; then
  echo "Impossible de récupérer le lien du téléchargement."
  exit 1
fi
echo "Téléchargement de RustDesk depuis : $DEB_URL"
curl -LO "$DEB_URL"
# Récupère le nom du fichier téléchargé
DEB_FILE=$(basename "$DEB_URL")
# Installe RustDesk
echo "Installation de $DEB_FILE"
sudo dpkg -i "$DEB_FILE" || sudo apt install -f -y
echo "RustDesk est installé avec succès."
# Pour empêcher RustDesk de démarrer automatiquement, et qu’il utilise des ressources, vous pouvez désactiver le service : cela ne gênera pas son utilisation.
sudo systemctl disable rustdesk
sudo systemctl stop rustdesk

# Anydesk : controle a distance (secours si rustdesk KO ou pour MacOS)
# Script Bash proposé par linux.secupc.fr
##########################################
# Add the AnyDesk GPG key
sudo apt install -y ca-certificates curl apt-transport-https
sudo install -m 0755 -d /etc/apt/keyrings
sudo curl -fsSL https://keys.anydesk.com/repos/DEB-GPG-KEY -o /etc/apt/keyrings/keys.anydesk.com.asc
sudo chmod a+r /etc/apt/keyrings/keys.anydesk.com.asc
# Add the AnyDesk apt repository
echo "deb [signed-by=/etc/apt/keyrings/keys.anydesk.com.asc] https://deb.anydesk.com all main" | sudo tee /etc/apt/sources.list.d/anydesk-stable.list > /dev/null
# Update apt caches and install the AnyDesk client
sudo apt install -y anydesk
# Ne pas lancer Anydesk en permanence
sudo systemctl disable anydesk.service 
sudo systemctl stop    anydesk.service 

### NOI = Toutes les IA !
# Script Bash proposé par linux.secupc.fr
##########################################
wget https://github.com/lencx/Noi/releases/download/v0.4.0/noi_linux_amd64_0.4.0.deb
sudo dpkg -i noi_linux_amd64_0.4.0.deb
sudo apt install -f

# discord
wget -O discord.deb "https://discordapp.com/api/download?platform=linux&format=deb"
sudo dpkg -i discord.deb

# Un petit coup de nettoyage ...
sudo apt-get autoclean  -y
sudo apt-get clean -y
sudo apt-get --purge autoremove -y

echo "Vérifez maintenant : TeamViewer, ClipGrab, param. Photofiltre et LibreOffice, Wine 32b ? (.wine/program files x86 ?..."
echo "Ajouter aux favoris du menu + sur le bureau : applications Skype, TeamViewer, Photofiltre..."
echo "Pierre-Jean MARQUET - SecuPC.fr"

