#!/bin/bash

echo "----- Sauvegarde smartphone Xiaomi Redmi 10C via ADB -----"
echo "Pour activer le débogage USB :"
echo "1) Allez dans Paramètres > À propos du téléphone > tapez 7 fois sur 'Numéro de build'"
echo "2) Puis dans Options pour les développeurs, activez 'Débogage USB'"
echo ""

# Vérifier si adb est installé
if ! command -v adb &> /dev/null; then
  echo "Erreur : adb n'est pas installé. Veuillez l'installer et relancer le script."
  exit 1
fi

# Lancer adb server
adb start-server

echo "Veuillez connecter votre téléphone Xiaomi au PC avec le débogage USB activé."
read -p "Appuyez sur Entrée quand c'est fait..."

# Vérifier que le téléphone est détecté
devices=$(adb devices | grep -w "device")
if [ -z "$devices" ]; then
  echo "Aucun appareil détecté. Veuillez vérifier la connexion et le débogage USB."
  exit 1
fi

echo "Téléphone détecté."

# Lister les dossiers disponibles dans /sdcard/
echo "Voici les dossiers disponibles dans /sdcard/ :"
adb shell ls /sdcard

# Demander le dossier à sauvegarder, défaut "tout"
read -p "Entrez le nom du dossier à sauvegarder (exemple : DCIM, Download, Music) ou appuyez sur Entrée pour tout sauvegarder : " folder

if [ -z "$folder" ]; then
  folder="tout"
fi

if [ "$folder" = "tout" ]; then
  source_path="/sdcard"
else
  # Vérifier que le dossier existe
  if ! adb shell ls "/sdcard/$folder" &> /dev/null; then
    echo "Le dossier spécifié n'existe pas dans /sdcard/. Fin du script."
    exit 1
  fi
  source_path="/sdcard/$folder"
fi

# Initialiser le dossier cible avec année-mois dans $HOME/Documents/Sauve-Telephones
base_dest="$HOME/Documents/Sauve-Telephones"
annee_mois=$(date +%Y-%m)
dest="$base_dest/$annee_mois"

# Créer dossier destination s'il n'existe pas
mkdir -p "$dest"

echo "Le dossier de destination est : $dest"

echo "Lancement de la sauvegarde depuis $source_path vers $dest"

adb pull "$source_path" "$dest"

echo "Sauvegarde terminée avec succès."

exit 0

