#!/bin/bash

function preRequis {
        for arg in $@; do
                if ! which $arg >/dev/null; then
			logger -t $0 La commande $arg n\'est pas installée
                        echo "La commande $arg n'est pas installée !!!"
                        echo "Fin du script."
                        exit 1
                fi
        done
}

logger -t $0 Exécution du script

PATH="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/games"

preRequis md5sum sort awk uniq grep cut

if [ ! $# -eq 1 ]; then
	echo "Erreur !!!"
	echo "Utilisation : $0 répertoire"
	exit 1
fi

FILE="/tmp/filesMd5sum"
REP="$1"

if [ ! -d "$REP" ]; then
	echo "Erreur !!!"
	echo "$REP n'est pas un répertoire."
	exit 1
fi

rm -f "$FILE"

find "$REP" -type f -exec md5sum -b {} \; > "$FILE"

DOUBLON=0

for file in $(cat "$FILE" | sort | awk '{print $1}' | uniq -d); do
	DOUBLON=1
	echo "Empreinte MD5 identique : $file"
	grep $file "$FILE" | cut -d' ' -f2
done

if [ "$DOUBLON" -eq 0 ]; then echo "Aucun doublon trouvé"; fi

logger -t $0 Fin d\'exécution du script

exit 0