#!/bin/bash

# Script d'installation de ProtonVPN sur Linux Mint / Ubuntu / Debian

set -e

echo "Mise à jour des dépôts..."
sudo apt update

echo "Installation des dépendances nécessaires..."
sudo apt install -y wget apt-transport-https

echo "Téléchargement du dépôt ProtonVPN..."
wget -O protonvpn-stable-release.deb https://repo.protonvpn.com/debian/dists/stable/main/binary-all/protonvpn-stable-release_1.0.8_all.deb

echo "Installation du dépôt ProtonVPN..."
sudo dpkg -i protonvpn-stable-release.deb

echo "Mise à jour des dépôts après ajout de ProtonVPN..."
sudo apt update

echo "Tentative d'installation de l'application graphique ProtonVPN..."
if sudo apt install -y proton-vpn-gnome-desktop; then
    echo "✅ ProtonVPN (interface graphique) est installé ! Lancez-le depuis le menu des applications."
else
    echo "❌ Impossible d'installer l'application graphique ProtonVPN."
    echo "Installation du client en ligne de commande (CLI) à la place..."
    sudo apt install -y protonvpn-cli
    echo "✅ ProtonVPN CLI est installé !"
    echo "Utilisez-le avec la commande : protonvpn-cli"
fi

echo "Nettoyage..."
rm -f protonvpn-stable-release.deb

echo "Installation terminée !"

