#!/bin/ksh                            
# set -x   # pour debugger les shells 
# ---> Verification de l'usage : 
if [ $# != 4 ]
then                                                                      
  echo
  echo " usage : $0 format-fichier repert-local machine-host repert-host" 
  echo " ex: $0 'maclo*' /user/magasin/magasin develop /usr/commun/magasin"
  echo " ex: $0 TOUS /user/magasin/magasin develop /usr/commun/magasin"
  echo
  exit 1                                                                 
fi
FFICH="$1"
if test $FFICH = "TOUS"
  then FFICH=*.[iap]
fi 
HMACHINE="$3"
LREP="$2"
HREP="$4"
FLOG=comp`date "+%d%m-%H%M"`
FERR=tmp`date "+%d%m-%H%M"`
> $FERR  #init a fichier vide (tjs)

  for i in `ls ${LREP}/$FFICH`
  do
      j=`basename $i`
      echo "$i..."
      if test -f $i 
      then
        rcp $i $HMACHINE:${HREP}/FICCOMP   # hdbm.s + msg's + ...
        if test $? -ne 0                                 
        then 
          echo "Echec : rcp $i $HMACHINE:${HREP}/FICCOMP" 
          echo "Echec : rcp $i $HMACHINE:${HREP}/FICCOMP" >> $FLOG
          # exit : fait sortir du batch ! non on continue...  
        fi
	> $FERR
  remsh $HMACHINE "cd $HREP;diff $j FICCOMP;if test $? -ne 0;then echo $i;fi" > $FERR
	if test $? -ne 0                                   
	then                                               
	  echo                                             
	  echo "Erreur remsh " $i                                            
	  echo "Erreur remsh $i" >> $FLOG
        fi
	if test -s $FERR  # fichier non vide ?
	then 
	  cat $FERR
	  echo "---------------- $i ---------------- DEBUT " >> $FLOG
	  cat $FERR >> $FLOG
	  echo "---------------- $i ------------------ FIN " >> $FLOG
	fi
      fi
  done
echo "Fin: " `date "+%d/%m %H:%M"`
rm $FERR
