#!/bin/ksh                            
# prog-comp.s -----------------------------------------------
# set -x   # pour debugger les shells 
echo "  Compare programmes source : "
if [ $# != 1 ]
then                                                                      
  echo
  echo " usage  : `basename $0` liste-prog-develop" 
  echo " exemple: `basename $0` maliste"
  echo
  exit 1                                                                 
fi
LISTEFIC="$1"
LREP=$PWD
HREP=/usr/commun
FLOG=`basename $0``date "+%d%m-%H%M"`.log
FDIFF=`basename $0``date "+%d%m-%H%M"`.diff
FTMP=`basename $0``date "+%d%m-%H%M"`.tmp
EXISTE=`basename $0``date "+%d%m-%H%M"`.resu
> $FLOG
for i in `cat $LISTEFIC`
do
   HBASENAME=`dirname $i`
   FICHIER=`basename $i`
   ##echo "$i..."
 echo "Compare $FICHIER : $HBASENAME <-> $LREP"
   # find retourne tjs 0 si trouve ou non trouve => tester chaine   
   find $HBASENAME -name "$FICHIER" > $EXISTE
   if test ! -s $EXISTE                                                  
   then                                                             
      echo "Fichier : $HBASENAME/$FICHIER n'existe pas !"
      read x
   else
      diff -b $FICHIER $HBASENAME > $FDIFF
      if test -s $FDIFF  # fichier non vide ?
      then 
        ## messages ecran
         echo "---------------- $i ---------------- DEBUT " 
         cat $FDIFF 
         echo "---------------- $i ------------------ FIN " 
         read x  # pause si diff.
        ## messages fichier log
         echo "---------------- $i ---------------- DEBUT " >> $FLOG
         cat $FDIFF >> $FLOG
         echo "---------------- $i ------------------ FIN " >> $FLOG
      else 
         echo "-> OK (pas de diff.) "
      fi
      rm $FDIFF
   fi
   rm $EXISTE
done
echo "Fin: " `date "+%d/%m %H:%M"`
