#!/bin/ksh                            
# set -x   # pour debugger les shells 
# ---> Verification de l'usage : 
if [ $# != 3 ]
then                                                                      
  echo
  echo " usage : $0 format-fichier repert1 repert2" 
  echo " ex: $0 '*.a' /usr/commun/magasin /usr/commun/france"
  echo " ex: $0 TOUS  /usr/commun/magasin /usr/commun/france"
  echo
  exit 1                                                                 
fi
FFICH="$1"
if test $FFICH = "TOUS"
  then FFICH=*.[iap]
fi 
REP1="$2"
REP2="$3"
FLOG=comp`date "+%d%m-%H%M"`
FERR=tmp`date "+%d%m-%H%M"`
> $FERR  #init a fichier vide (tjs)
  for i in `ls ${REP1}/$FFICH`
  do
      j=`basename $i`
      echo "$i..."
      if test -f $i 
      then
        diff $REP1/$j $REP2/$j > $FERR
      fi
      if test -s $FERR  # fichier non vide ?
      then 
          cat $FERR
	  echo "---------------- $i ---------------- DEBUT " >> $FLOG
	  cat $FERR >> $FLOG
	  echo "---------------- $i ------------------ FIN " >> $FLOG
      fi
  done
echo "Fin: " `date "+%d/%m %H:%M"`
rm $FERR
